/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.layers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.compactmods.crafting.api.recipe.layers.RecipeLayerType;
import dev.compactmods.crafting.core.CCLayerTypes;
import net.minecraft.resources.ResourceLocation;

public final class RecipeLayerTypeCodec
implements Codec<RecipeLayerType<?>> {
    public static final Codec<RecipeLayerType<?>> INSTANCE = new RecipeLayerTypeCodec();

    private RecipeLayerTypeCodec() {
    }

    public static <T> DataResult<Pair<RecipeLayerType<?>, T>> handleDecodeResult(Pair<ResourceLocation, T> keyValuePair) {
        ResourceLocation id = (ResourceLocation)keyValuePair.getFirst();
        if (!CCLayerTypes.RECIPE_LAYER_TYPES.containsKey(id)) {
            return DataResult.error((String)("Unknown registry key: " + id));
        }
        return DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> CCLayerTypes.RECIPE_LAYER_TYPES.getValue(arg_0)));
    }

    public <T> DataResult<Pair<RecipeLayerType<?>, T>> decode(DynamicOps<T> ops, T input) {
        return ResourceLocation.f_135803_.decode(ops, input).flatMap(RecipeLayerTypeCodec::handleDecodeResult);
    }

    public <T> DataResult<T> encode(RecipeLayerType<?> input, DynamicOps<T> ops, T prefix) {
        ResourceLocation key = input.getRegistryName();
        if (key == null) {
            return DataResult.error((String)("Unknown registry element " + input));
        }
        Object toMerge = ops.createString(key.toString());
        return ops.mergeToPrimitive(prefix, toMerge);
    }
}

